//
//  OPDownloadModule.h
//  Image Downloader
//
//  Created by Nathan Van Fleet on 2015-05-29.
//  Copyright (c) 2015 Nathan Van Fleet. All rights reserved.
//

#import <Foundation/Foundation.h>

@protocol OPDataModuleDelegate;

// The behaviour we need from a implemented type

@protocol OPDataModule <NSObject>
@required

// Called by the controller
- (void)execute;

// Set by the controller receive information from the module
@property (nonatomic, weak) id <OPDataModuleDelegate> delegate;

@optional

// If a module is active when you cancel and it implements cancel it will be messaged by the controller to cancel.
- (void)cancel;

// Whether or not the module was successful
- (BOOL)wasSuccessful;
@end

@protocol OPDataModuleProcessor <OPDataModule>
@required
// If an object implements this than we pass result into this object.
// Set by the controller
@property (nonatomic,strong) id inputObject;
- (Class)inputObjectClass;
@end

// The protocol to have the module update its state with the controller

@protocol OPDataModuleDelegate <NSObject>
- (void)dataModule:(id <OPDataModule>)module didCompleteWithResult:(id)result error:(NSError *)error;
- (void)dataModule:(id <OPDataModule>)module didReachPercentCompletion:(float)percentage;
@end


